/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRCreativeTabs;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class LOTRItemMapPlus
extends Item {
    private static final int MAX_DISTANCE = 5000;
    private static final int LOOT_COUNT = 6;
    private IIcon inactiveIcon;
    private IIcon activeIcon;

    public LOTRItemMapPlus() {
        this.func_77637_a(LOTRCreativeTabs.tabMisc);
        this.func_77625_d(1);
    }

    public boolean func_77636_d(ItemStack par1ItemStack) {
        return true;
    }

    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.epic;
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.inactiveIcon = iconRegister.func_94245_a("lotr:map_inactive");
        this.activeIcon = iconRegister.func_94245_a("lotr:map_active");
        this.field_77791_bV = this.inactiveIcon;
    }

    public IIcon getIcon(ItemStack stack, int renderPass) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("isGenerated")) {
            return this.activeIcon;
        }
        return this.inactiveIcon;
    }

    public IIcon func_77650_f(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("isGenerated")) {
            return this.activeIcon;
        }
        return this.inactiveIcon;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            if (!stack.func_77942_o() || !stack.func_77978_p().func_74767_n("isGenerated")) {
                this.createTreasureMap(stack, player);
            } else if (this.isPlayerAtTreasure(stack, player)) {
                this.discoverTreasure(stack, world, player);
            }
        }
        return stack;
    }

    private void createTreasureMap(ItemStack stack, EntityPlayer player) {
        NBTTagCompound tag = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        Random random = new Random();
        int targetX = (int)player.field_70165_t + random.nextInt(5000) - random.nextInt(5000);
        int targetZ = (int)player.field_70161_v + random.nextInt(5000) - random.nextInt(5000);
        tag.func_74757_a("isGenerated", true);
        tag.func_74768_a("targetX", targetX);
        tag.func_74768_a("targetZ", targetZ);
        stack.func_77982_d(tag);
        String message = StatCollector.func_74837_a((String)"lotr.map.activated.message", (Object[])new Object[]{targetX, targetZ});
        player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + message));
        player.field_70170_p.func_72956_a((Entity)player, "lotr:mapsound", 0.5f, 1.0f + (field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.1f);
    }

    private boolean isPlayerAtTreasure(ItemStack stack, EntityPlayer player) {
        NBTTagCompound tag = stack.func_77978_p();
        int targetX = tag.func_74762_e("targetX");
        int targetZ = tag.func_74762_e("targetZ");
        return Math.floor(player.field_70165_t) == (double)targetX && Math.floor(player.field_70161_v) == (double)targetZ;
    }

    private void discoverTreasure(ItemStack stack, World world, EntityPlayer player) {
        --stack.field_77994_a;
        List<ItemStack> loot = this.generateLoot(world, player);
        Collections.shuffle(loot);
        ArrayList<String> obtainedLootMessages = new ArrayList<String>();
        for (int i = 0; i < 6; ++i) {
            ItemStack lootItem = loot.get(i);
            String rarityColor = this.getRarityColor(lootItem);
            String lootMessage = rarityColor + lootItem.func_82833_r();
            obtainedLootMessages.add(lootMessage);
            if (player.field_71071_by.func_70441_a(lootItem)) continue;
            player.func_71019_a(lootItem, false);
        }
        String obtainedItemsMessage = String.join((CharSequence)", ", obtainedLootMessages);
        String chatMessage = EnumChatFormatting.GREEN + StatCollector.func_74837_a((String)"lotr.map.treasure.received", (Object[])new Object[]{obtainedItemsMessage});
        player.func_145747_a((IChatComponent)new ChatComponentText(chatMessage));
        world.func_72956_a((Entity)player, "lotr:event.trade", 0.5f, 1.0f + (field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.1f);
    }

    private List<ItemStack> generateLoot(World world, EntityPlayer player) {
        Random rand = new Random();
        ArrayList<ItemStack> lootList = new ArrayList<ItemStack>();
        LOTRLevelData.getData(player).addAchievement(LOTRAchievement.treasure);
        lootList.add(new ItemStack(LOTRMod.silverCoin, rand.nextInt(3) + 1, 2));
        lootList.add(new ItemStack(LOTRMod.ruby, rand.nextInt(3) + 2));
        lootList.add(new ItemStack(LOTRMod.emerald, rand.nextInt(3) + 2));
        lootList.add(new ItemStack(LOTRMod.opal, rand.nextInt(3) + 2));
        lootList.add(new ItemStack(LOTRMod.sapphire, rand.nextInt(3) + 2));
        lootList.add(new ItemStack(LOTRMod.diamond, rand.nextInt(3) + 2));
        lootList.add(new ItemStack(LOTRMod.bronzeNugget, rand.nextInt(3) + 2));
        lootList.add(new ItemStack(LOTRMod.ironRaw, rand.nextInt(3) + 2));
        lootList.add(new ItemStack(LOTRMod.goldRaw, rand.nextInt(3) + 2));
        lootList.add(new ItemStack(Items.field_151043_k, rand.nextInt(3) + 2));
        lootList.add(new ItemStack(LOTRMod.anglePotterySherd));
        if (rand.nextDouble() < 0.3) {
            lootList.add(new ItemStack(LOTRMod.silverRing, rand.nextInt(1) + 5));
            lootList.add(new ItemStack(LOTRMod.goldRing, rand.nextInt(1) + 5));
            lootList.add(new ItemStack(LOTRMod.mithrilRing, rand.nextInt(1) + 4));
            lootList.add(new ItemStack(LOTRMod.stoneKili));
            lootList.add(new ItemStack(LOTRMod.mithrilNugget, rand.nextInt(1) + 4));
            lootList.add(new ItemStack(LOTRMod.gobletSilver, rand.nextInt(1) + 4));
            lootList.add(new ItemStack(LOTRMod.gobletGold, rand.nextInt(1) + 4));
            lootList.add(new ItemStack(LOTRMod.mithril));
            lootList.add(new ItemStack(LOTRMod.DragonTalon));
            lootList.add(new ItemStack(LOTRMod.silverCoin, rand.nextInt(20) + 1, 1));
            lootList.add(new ItemStack(LOTRMod.silver, rand.nextInt(3) + 3));
            if (rand.nextDouble() < 0.15) {
                lootList.add(new ItemStack(LOTRMod.totemOfUndying));
                lootList.add(new ItemStack(LOTRMod.treasureMap));
                lootList.add(new ItemStack(LOTRMod.silverCoin, rand.nextInt(10) + 1, 2));
                lootList.add(new ItemStack(LOTRMod.magicClover));
                lootList.add(new ItemStack(LOTRMod.mithril));
                lootList.add(new ItemStack(LOTRMod.ringClover));
                lootList.add(new ItemStack(LOTRMod.DragonTalon, rand.nextInt(1) + 3));
                lootList.add(new ItemStack(LOTRMod.stoneKili));
                lootList.add(new ItemStack(LOTRMod.stoneKiliPlus));
                lootList.add(new ItemStack(LOTRMod.gobletMithril, rand.nextInt(1) + 3));
                world.func_72956_a((Entity)player, "random.levelup", 0.5f, 1.0f);
            }
            if (rand.nextDouble() < 0.098) {
                lootList.add(new ItemStack(LOTRMod.treasureMap));
                lootList.add(new ItemStack(LOTRMod.treasureMapPlus));
                lootList.add(new ItemStack(LOTRMod.ring_bright));
                lootList.add(new ItemStack(LOTRMod.ringClover));
                lootList.add(new ItemStack(LOTRMod.durinScroll));
                lootList.add(new ItemStack(LOTRMod.DragonTalon, rand.nextInt(3) + 5));
                lootList.add(new ItemStack(LOTRMod.totemOfUndying, rand.nextInt(1) + 1));
                lootList.add(new ItemStack(LOTRMod.silverCoin, rand.nextInt(3) + 1, 3));
                lootList.add(new ItemStack(LOTRMod.totemOfUndyingPlus, rand.nextInt(1) + 1));
                lootList.add(new ItemStack(LOTRMod.magicClover, rand.nextInt(1) + 1));
                lootList.add(new ItemStack(LOTRMod.gobletMithril, rand.nextInt(1) + 3));
                lootList.add(new ItemStack(LOTRMod.diggingBook2));
                lootList.add(new ItemStack(LOTRMod.mithrilRaw));
                lootList.add(new ItemStack(LOTRMod.graalGold));
                LOTRLevelData.getData(player).addAchievement(LOTRAchievement.treasureRare);
                world.func_72956_a((Entity)player, "lotr:item.levelup", 0.5f, 1.0f);
            }
            if (rand.nextDouble() < 0.088) {
                lootList.add(new ItemStack(LOTRMod.treasureMap));
                lootList.add(new ItemStack(LOTRMod.durinScroll));
                lootList.add(new ItemStack(LOTRMod.durinScrollPlus));
                lootList.add(new ItemStack(LOTRMod.treasureMapPlus));
                lootList.add(new ItemStack(LOTRMod.ringClover));
                lootList.add(new ItemStack(LOTRMod.stoneKili));
                lootList.add(new ItemStack(LOTRMod.stoneKiliPlus));
                lootList.add(new ItemStack(LOTRMod.ring_bright));
                lootList.add(new ItemStack(LOTRMod.silverCoin, rand.nextInt(10) + 1, 3));
                lootList.add(new ItemStack(LOTRMod.totemOfUndying, rand.nextInt(1) + 2));
                lootList.add(new ItemStack(LOTRMod.totemOfUndyingPlus, rand.nextInt(1) + 2));
                lootList.add(new ItemStack(LOTRMod.magicClover, rand.nextInt(1) + 3));
                lootList.add(new ItemStack(LOTRMod.magicCloverPlus));
                lootList.add(new ItemStack(LOTRMod.graalMithril));
                lootList.add(new ItemStack(LOTRMod.diggingBook2, rand.nextInt(1) + 2));
                lootList.add(new ItemStack(LOTRMod.soulboundBook, rand.nextInt(1) + 2));
                LOTRLevelData.getData(player).addAchievement(LOTRAchievement.treasureUltraRare);
                world.func_72956_a((Entity)player, "lotr:item.levelupskyrim", 0.5f, 1.0f);
            }
            if (rand.nextDouble() < 0.008) {
                ItemStack coinStack = new ItemStack(LOTRMod.silverCoin, 1, 6);
                if (player.field_71071_by.func_70441_a(coinStack)) {
                    LOTRLevelData.getData(player).addAchievement(LOTRAchievement.treasureMillionere);
                    world.func_72956_a((Entity)player, "lotr:item.millionere", 0.5f, 1.0f);
                } else {
                    player.func_71019_a(coinStack, false);
                }
            }
        }
        return lootList;
    }

    private String getFormattedItemName(ItemStack item) {
        String itemName = item.func_82833_r();
        String rarityColor = this.getRarityColor(item);
        return rarityColor + itemName + EnumChatFormatting.GREEN;
    }

    private String getRarityColor(ItemStack item) {
        if (item.func_77973_b() == LOTRMod.totemOfUndyingPlus || item.func_77973_b() == LOTRMod.graalMithril || item.func_77973_b() == LOTRMod.magicCloverPlus || item.func_77973_b() == LOTRMod.ring_bright || item.func_77973_b() == LOTRMod.graalGold || item.func_77973_b() == LOTRMod.durinScrollPlus || item.func_77973_b() == LOTRMod.treasureMapPlus || item.func_77973_b() == LOTRMod.mithrilRaw) {
            return EnumChatFormatting.GOLD.toString();
        }
        if (item.func_77973_b() == LOTRMod.totemOfUndying || item.func_77973_b() == LOTRMod.magicClover || item.func_77973_b() == LOTRMod.stoneKili || item.func_77973_b() == LOTRMod.stoneKiliPlus || item.func_77973_b() == LOTRMod.gobletMithril || item.func_77973_b() == LOTRMod.durinScroll || item.func_77973_b() == LOTRMod.mithrilNugget || item.func_77973_b() == LOTRMod.diggingBook2 || item.func_77973_b() == LOTRMod.soulboundBook) {
            return EnumChatFormatting.DARK_PURPLE.toString();
        }
        if (item.func_77973_b() == LOTRMod.silverRing || item.func_77973_b() == LOTRMod.goldRing || item.func_77973_b() == LOTRMod.mithrilRing || item.func_77973_b() == LOTRMod.gobletSilver || item.func_77973_b() == LOTRMod.gobletGold || item.func_77973_b() == LOTRMod.treasureMap || item.func_77973_b() == LOTRMod.silver) {
            return EnumChatFormatting.BLUE.toString();
        }
        return EnumChatFormatting.GREEN.toString();
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        super.func_77624_a(stack, player, list, advanced);
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag.func_74767_n("isGenerated")) {
                int targetX = tag.func_74762_e("targetX");
                int targetZ = tag.func_74762_e("targetZ");
                list.add(EnumChatFormatting.YELLOW + "X: " + targetX + " Z: " + targetZ);
                list.add(EnumChatFormatting.GREEN + StatCollector.func_74837_a((String)"lotr.map.activated", (Object[])new Object[0]));
                if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                    list.add(EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"lotr.map.treasure.chances"));
                    list.add(EnumChatFormatting.GRAY + "\u25cf Common: " + EnumChatFormatting.GRAY + "70%");
                    list.add(EnumChatFormatting.BLUE + "\u25cf Rare: " + EnumChatFormatting.BLUE + "30%");
                    list.add(EnumChatFormatting.AQUA + "\u25cf Rare+: " + EnumChatFormatting.AQUA + "15%");
                    list.add(EnumChatFormatting.DARK_PURPLE + "\u25cf Ultra Rare: " + EnumChatFormatting.DARK_PURPLE + "9.8%");
                    list.add(EnumChatFormatting.GOLD + "\u25cf Legendary: " + EnumChatFormatting.GOLD + "0.8%");
                } else {
                    list.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"lotr.map.treasure.holdShift"));
                }
            } else {
                list.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"right.name"));
            }
        } else {
            list.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"right.name"));
        }
    }
}

